﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Microsoft.Reporting.WinForms;

namespace RaportMacierzowy
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void PobierzDane()
        {
            this.NorthwindDataSet.Employee_Sales_by_Country.Clear();
            this.Employee_Sales_by_CountryTableAdapter.ClearBeforeFill = false;

            if (checkBox1.Checked)
                this.Employee_Sales_by_CountryTableAdapter.
                    Fill(this.NorthwindDataSet.Employee_Sales_by_Country,
                    new DateTime(1996, 1, 1), new DateTime(1996, 12, 31));

            if (checkBox2.Checked)
                this.Employee_Sales_by_CountryTableAdapter.
                    Fill(this.NorthwindDataSet.Employee_Sales_by_Country,
                    new DateTime(1997, 1, 1), new DateTime(1997, 12, 31));

            if (checkBox3.Checked)
                this.Employee_Sales_by_CountryTableAdapter.
                    Fill(this.NorthwindDataSet.Employee_Sales_by_Country,
                    new DateTime(1998, 1, 1), new DateTime(1998, 12, 31));

            foreach (NorthwindDataSet.Employee_Sales_by_CountryRow dr in
                NorthwindDataSet.Employee_Sales_by_Country.Rows)
            {
                switch (dr.ShippedDate.Year)
                {
                    case 1996:
                        dr.Year = "1996";
                        break;
                    case 1997:
                        dr.Year = "1997";
                        break;
                    case 1998:
                        dr.Year = "1998";
                        break;
                }
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            // TODO: This line of code loads data into the 'NorthwindDataSet.Employee_Sales_by_Country' table. You can move, or remove it, as needed.
            //this.Employee_Sales_by_CountryTableAdapter.
            //    Fill(this.NorthwindDataSet.Employee_Sales_by_Country, 
            //    new DateTime(1996, 1, 1), new DateTime(1998, 12, 31));                     

            PobierzDane();

            //foreach (NorthwindDataSet.Employee_Sales_by_CountryRow dr in 
            //    NorthwindDataSet.Employee_Sales_by_Country.Rows)
            //{                
            //    switch(dr.ShippedDate.Year)
            //    {
            //        case 1996:
            //            dr.Year = "1996";
            //            break;
            //        case 1997:
            //            dr.Year = "1997";
            //            break;
            //        case 1998:
            //            dr.Year = "1998";
            //            break;
            //    }
            //}

            this.reportViewer1.RefreshReport();
        }

        private void comboBox1_SelectedValueChanged(object sender, EventArgs e)
        {
            // Tablica wartości parametru
            string[] wartosci = new string[comboBox1.Items.Count];
            
            // Ustalenie wartości parametru na podstawie 
            // elementów komponentu ComboBox
            if(comboBox1.SelectedItem.ToString() == "Wszystkie")
            {
                for (int i = 0; i < comboBox1.Items.Count; i++)
                {
                    if (comboBox1.Items[i].ToString() == "Wszystkie")
                        continue;
                    else
                        wartosci[i] = comboBox1.Items[i].ToString();
                }
            }
            else
                wartosci[0] = comboBox1.SelectedItem.ToString();
            
            // Przekazanie wartości parametru w celu uaktualnienia filtru raportu
            ReportParameter rp = new ReportParameter("CountryName", wartosci);
            reportViewer1.LocalReport.SetParameters(new ReportParameter[] { rp });   
            
            // Odświeżenie raportu
            reportViewer1.RefreshReport();
        }        

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            PobierzDane();
            reportViewer1.RefreshReport();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            int KPI;
            // Czy pole tekstowe zawiera wartość liczbową?
            if(Int32.TryParse(textBox1.Text, out KPI))
            {
                ReportParameter rp = new ReportParameter("KPI", textBox1.Text);
                reportViewer1.LocalReport.SetParameters(new ReportParameter[] { rp });
                reportViewer1.RefreshReport();  
            }
        }

    }
}
